# User stories and Functional Specifications: POMS for Android 

POMS is the name of a prosthetics and orthotics monitoring system that allows
an IOT connection from a small embedded sensor into a gateway which will send
report data into a server that is to be deployed at a clinic.

To this end we will describe the following functional requirements:

### 1. Recieve data from the SensorsysTX device
- The SensorSysTx device utilizes bluetooth Low energy to broadcast reports and
  data over the air. The POMS for Android shall have to make use of the
  bluetooth api in order to recieve files from the sensor, validate their
  signature and send them off to the server in order to track data.

### 2. Display and preview the data 
- The POMS for Android device shall be able to decrypt and preview the data
  locally, provided that the the local user is allowed to view it. 
- Transmission to the server shall still be encrypted 
  
### 3. Encryption and authorization
- POMS for Android device shall allow the user to authorize themselves in order
  to be be able to decrypt incomming packets. Additionally the user will have
  the choice of whether or not data from other devices can be transmitted to
  the server.

Additionally we also describe the following User stories:

### 4. As a Scoliosis Patient 
As a scoliosis Patient I would like to have the ability to see what kind of
information gets collected from me. As well as be able to use any kind of
fitness or activity tracking for my own personal usage.

### 5. As a parent 
As a parent of somebody with scoliosis, I would like to have the ability to
monitor whether or not my child is following the treatment properly or not. 

### 6. As a Clinician 
As a clinician I would like to be able to see wear time data from our patients
through an application and have the visible data tied to each patient and each
sensor.

### 7. As a Young patient I sometimes forget to wear the scoliosis brace, 
if the app detects that I have not worn the brace for a while I would like to
optionally be reminded to wear the brace.

### 8. As an active and busy person 
I may be without internet access for quite a while. In these cases I would like
the app to keep the data locally and transmit it only when I have internet
access again.

### 9. As a patient 
I would like to have access to the clinic's contact information so that I can
message them my concerns or questions whenever I have them.
